<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->name) && !empty($data->email) && !empty($data->password)) {
    $check_query = "SELECT id FROM users WHERE email = :email";
    $check_stmt = $db->prepare($check_query);
    $check_stmt->bindParam(":email", $data->email);
    $check_stmt->execute();

    if ($check_stmt->rowCount() > 0) {
        echo json_encode([
            "success" => false,
            "message" => "Email sudah terdaftar"
        ]);
    } else {
        $query = "INSERT INTO users (name, email, password) VALUES (:name, :email, :password)";
        $stmt = $db->prepare($query);
        
        $stmt->bindParam(":name", $data->name);
        $stmt->bindParam(":email", $data->email);
        $hashed_password = password_hash($data->password, PASSWORD_DEFAULT);
        $stmt->bindParam(":password", $hashed_password);

        if ($stmt->execute()) {
            echo json_encode([
                "success" => true,
                "message" => "Registrasi berhasil"
            ]);
        } else {
            echo json_encode([
                "success" => false,
                "message" => "Registrasi gagal"
            ]);
        }
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Semua field harus diisi"
    ]);
}
?>
