<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->user_id) && !empty($data->category) && !empty($data->planned_amount) && !empty($data->month)) {
    $query = "INSERT INTO budgets (user_id, category, planned_amount, month) 
              VALUES (:user_id, :category, :planned_amount, :month)
              ON DUPLICATE KEY UPDATE planned_amount = :planned_amount2";
    
    $stmt = $db->prepare($query);
    
    $stmt->bindParam(":user_id", $data->user_id);
    $stmt->bindParam(":category", $data->category);
    $stmt->bindParam(":planned_amount", $data->planned_amount);
    $stmt->bindParam(":planned_amount2", $data->planned_amount);
    $stmt->bindParam(":month", $data->month);

    if ($stmt->execute()) {
        echo json_encode([
            "success" => true,
            "message" => "Budget berhasil ditambahkan"
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Gagal menambahkan budget"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Data tidak lengkap"
    ]);
}
?>
