<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->user_id) && !empty($data->old_password) && !empty($data->new_password)) {
    // Verify old password
    $query = "SELECT password FROM users WHERE id = :user_id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(":user_id", $data->user_id);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (password_verify($data->old_password, $row['password'])) {
            // Update password
            $query2 = "UPDATE users SET password = :password WHERE id = :user_id";
            $stmt2 = $db->prepare($query2);
            $stmt2->bindParam(":user_id", $data->user_id);
            $hashed_password = password_hash($data->new_password, PASSWORD_DEFAULT);
            $stmt2->bindParam(":password", $hashed_password);
            
            if ($stmt2->execute()) {
                echo json_encode([
                    "success" => true,
                    "message" => "Password berhasil diubah"
                ]);
            } else {
                echo json_encode([
                    "success" => false,
                    "message" => "Gagal mengubah password"
                ]);
            }
        } else {
            echo json_encode([
                "success" => false,
                "message" => "Password lama salah"
            ]);
        }
    } else {
        echo json_encode([
            "success" => false,
            "message" => "User tidak ditemukan"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Data tidak lengkap"
    ]);
}
?>
