<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->user_id) && !empty($data->name)) {
    $query = "UPDATE users SET name = :name, phone = :phone WHERE id = :user_id";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(":user_id", $data->user_id);
    $stmt->bindParam(":name", $data->name);
    $phone = isset($data->phone) ? $data->phone : null;
    $stmt->bindParam(":phone", $phone);

    if ($stmt->execute()) {
        // Get updated user data
        $query2 = "SELECT id, name, email, phone, photo_url FROM users WHERE id = :user_id";
        $stmt2 = $db->prepare($query2);
        $stmt2->bindParam(":user_id", $data->user_id);
        $stmt2->execute();
        $user = $stmt2->fetch(PDO::FETCH_ASSOC);

        echo json_encode([
            "success" => true,
            "message" => "Profile berhasil diupdate",
            "data" => $user
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Gagal mengupdate profile"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "Data tidak lengkap"
    ]);
}
?>
