<?php
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$data = json_decode(file_get_contents("php://input"));

if (!empty($data->id)) {
    $query = "UPDATE transactions SET 
              type = :type,
              amount = :amount,
              category = :category,
              description = :description,
              date = :date
              WHERE id = :id AND user_id = :user_id";
    
    $stmt = $db->prepare($query);
    
    $stmt->bindParam(":id", $data->id);
    $stmt->bindParam(":user_id", $data->user_id);
    $stmt->bindParam(":type", $data->type);
    $stmt->bindParam(":amount", $data->amount);
    $stmt->bindParam(":category", $data->category);
    $stmt->bindParam(":description", $data->description);
    $date = date('Y-m-d', strtotime($data->date));
    $stmt->bindParam(":date", $date);

    if ($stmt->execute()) {
        echo json_encode([
            "success" => true,
            "message" => "Transaksi berhasil diupdate"
        ]);
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Gagal mengupdate transaksi"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "message" => "ID transaksi tidak ditemukan"
    ]);
}
?>
